# ORIGIN 源点-浏览器起始页
## 项目概览
> 浏览器的起始页，包括常用页面收藏、搜索引擎、备忘提示录功能  
> 集成多家搜索引擎，优化导航栏样式，提示备忘录多处显示
> url跳转搜索框，分离引擎关键词搜索框与url跳转  
## 实现方案
> 搜索引擎集成多个搜索引擎，用localStorage储存备忘提示录、网页收藏夹，在title、页面中显示备忘录事项
### 多引擎集成
> 根据用户选择的搜索引擎向特定的searchUrl提交搜索
```js
//搜索部分逻辑
search() {
    if (!this.searchQuery.trim()) return;
    let searchUrl;
    switch (this.selectedEngine) {
        case 'bing':
            searchUrl = `https://www.bing.com/search?q=${encodeURIComponent(this.searchQuery)}`;
            break;
        case 'google':
            searchUrl = `https://www.google.com/search?q=${encodeURIComponent(this.searchQuery)}`;
            break;
        case 'baidu':
            searchUrl = `https://www.baidu.com/s?wd=${encodeURIComponent(this.searchQuery)}`;
            break;
    }
    window.open(searchUrl, '_blank');
},
```
### 备忘录功能
> 利用vue框架以及localstorage储存技术实现备忘录功能，方便用户打开引擎时看到当前存在的代办事项，同时在title元素中填充第一条待办事项，使用户在其他页面也能看到当前的代办事项
```js
addTodo() {
    const text = this.todoText.trim();
    if (!text) return;
    this.todoList.push(text);
    localStorage.setItem('todoList', JSON.stringify(this.todoList)); 
    this.todoText = '';
    // 更新标题
    if (this.todoList.length > 0) {
        document.title = `待办: ${this.todoList[0]}`;
    } else {
        document.title = '起始页 - 起始頁';
    }
},
completeTodo(idx) {
    this.todoList.splice(idx, 1);
    localStorage.setItem('todoList', JSON.stringify(this.todoList));
    // 更新标题
    if (this.todoList.length > 0) {
        document.title = `待办: ${this.todoList[0]}`;
    } else {
        document.title = '起始页 - 起始頁';
    }
},
loadTodo() {
    const saved = localStorage.getItem('todoList');
    this.todoList = saved ? JSON.parse(saved) : [];
    // 初始化时也同步标题
    if (this.todoList.length > 0) {
        document.title = `待办: ${this.todoList[0]}`;
    } else {
        document.title = '起始页 - 起始頁';
    }
},
```
### 网页收藏夹
> 同样用localstorage储存技术储存收藏的网页
```js
showAddSite(idx) {
    this.addSiteFolderIdx = idx;
    this.newSiteName = '';
    this.newSiteUrl = '';
},
addSite(idx) {
    const siteName = this.newSiteName.trim();
    const siteUrl = this.newSiteUrl.trim();
    if (!siteName || !siteUrl) return;
    const newSite = { name: siteName, url: siteUrl };
    this.siteFolders[idx].sites.push(newSite);
    this.addSiteFolderIdx = null;
    localStorage.setItem('siteFolders', JSON.stringify(this.siteFolders));
},
cancelAddSite() {
    this.addSiteFolderIdx = null;
},
addFolder() {
    const folderName = this.newFolderName.trim();
    if (!folderName) return;
    const newFolder = { name: folderName, sites: [] };
    this.siteFolders.push(newFolder);
    this.showAddFolder = false;
    this.newFolderName = '';
    localStorage.setItem('siteFolders', JSON.stringify(this.siteFolders));
},
```

